package treeNAlgo;

import treeN.*;
import extvisitor.*;

/**
 * Splits host upwards if its state &gt; order and passes the host to the
 * supplied param, which is an ISpliceCmd, to do some "abstract splicing".
 * 
 * Uses lambda-based extended visitors
 */
class SplitUpAndApply2<E> extends ATreeNAlgo<E, TreeN<E>, ILambda<TreeN<E>, TreeN<E>>> {
  

  /**
   * Installs no-op cmd for states <= order
   */
  public SplitUpAndApply2(int order) {
    super(new IExtVisitorCmd<TreeN<E>,Integer, ILambda<TreeN<E>, TreeN<E>>, TreeN<E>>(){
      public TreeN<E> apply(Integer index, TreeN<E> host, ILambda<TreeN<E>, TreeN<E>>... cmds) {
        host.splitUpAt(index/2);   // push data up
        return cmds[0].apply(host); // "splice" host into something!
      }
    });
    
    IExtVisitorCmd<TreeN<E>,Integer, ILambda<TreeN<E>, TreeN<E>>, TreeN<E>> cmd  
      = new IExtVisitorCmd<TreeN<E>,Integer, ILambda<TreeN<E>, TreeN<E>>, TreeN<E>>(){
      public TreeN<E> apply(Integer index, TreeN<E> host, ILambda<TreeN<E>, TreeN<E>>... cmds) {
        return host;
      }
    };
    
    for(int i=0; i<=order; i++) setCmd(i, cmd);
  }
}

